<?php

class Partner_Module_Helper_Csv extends Mage_Core_Helper_Abstract
{
    const DIRECTORY_NAME = 'partner';

    const FILE_NAME = 'failed_export.csv';

    const HEADERS = [
        'programid',
        'type',
        'partnerid',
        'userip',
        'ordreid',
        'varenummer',
        'antal',
        'omprsalg',
        'pacid'
    ];

    private $resource = null;

    /**
     * @return string
     */
    protected function getDirectory()
    {
        return trim(self::DIRECTORY_NAME,DIRECTORY_SEPARATOR);
    }

    /**
     * @return string
     */
    protected function getVarPath()
    {
        return rtrim(Mage::getBaseDir(Mage_Core_Model_Config_Options::VAR_DIRECTORY),DIRECTORY_SEPARATOR);
    }

    /**
     * @return string
     */
    public function getFilePath()
    {
        return $this->getVarPath() . DIRECTORY_SEPARATOR . $this->getDirectory() . DIRECTORY_SEPARATOR . trim(self::FILE_NAME, DIRECTORY_SEPARATOR);;
    }

    /**
     * @return string
     */
    protected function getContent()
    {
        $directoryPath = $this->getVarPath() . DIRECTORY_SEPARATOR . $this->getDirectory();

        if (file_exists($directoryPath) || mkdir($directoryPath,0777,true) === true || is_dir($directoryPath)) {

            $filePath = $directoryPath . DIRECTORY_SEPARATOR . trim(self::FILE_NAME, DIRECTORY_SEPARATOR);

            if (file_exists($filePath) || true === touch($filePath)) {
                return file_get_contents($filePath);
            }
        }

        return '';
    }

    /**
     * @param $data
     * @return bool|false|int
     */
    protected function appendContent($data)
    {
        $directoryPath = $this->getVarPath() . DIRECTORY_SEPARATOR . $this->getDirectory();

        if (file_exists($directoryPath) || mkdir($directoryPath,0777,true) === true || is_dir($directoryPath)) {

            $filePath = $directoryPath . DIRECTORY_SEPARATOR . trim(self::FILE_NAME, DIRECTORY_SEPARATOR);

            if (file_exists($filePath) || true === touch($filePath)) {
                return file_put_contents($filePath, $data, LOCK_EX | FILE_APPEND);
            }
        }

        return false;
    }

    /**
     * @param array $values
     * @return string
     */
    protected function csvString(array $values)
    {
        $string = '';

        foreach ($values as $value) {
            $string .= '"' . strtr(((string)$value), ['"' => '\\\\"']) . '",';
        }

        return trim($string,',').PHP_EOL;
    }

    /**
     * @param array $array
     */
    public function logData(array $array)
    {
        $data = $this->getContent();

        if (empty(trim($data))) {
            $this->appendContent($this->csvString(self::HEADERS));
        }

        if (count(self::HEADERS) === count($array)) {
            $this->appendContent($this->csvString($array));
        }
    }
}
