<?php
/**
 * https://www.wexo.dk/
 *
 * @author    Paul-Daniel Savlovschi <paul@wexo.dk>
 * @copyright Copyright (c) 2018, WEXO A/S
 */

class Partner_Module_Helper_Data extends Mage_Core_Helper_Abstract
{
    /**
     * Time for cooking in seconds
     */
    const COOKIE_TIME = '3456000';

    /**
     * XML Config path for the program type
     */
    const PROGRAM_TYPE_XML_PATH = 'partner/partner_group/program_type';

    /**
     * XML Config path for the program id
     */
    const PROGRAM_ID_XML_PATH = 'partner/partner_group/program_id';

    /**
     * XML Config path for test mode
     */
    const TEST_MODE_XML_PATH = 'partner/partner_group/test_mode';

    /**
     * XML Config path for debug mode
     */
    const DEBUG_MODE_XML_PATH = 'partner/partner_group/debug_mode';

    /**
     * XML Config path for enabled
     */
    const ENALBED_XML_PATH = 'partner/partner_group/enabled';

    /**
     * XML Config path for test endpoint
     */
    const TEST_ENDPOINT_XML_PATH = 'partner/partner_group/test_endpoint';

    /**
     * XML Config path for mode
     */
    const MODE_XML_PATH = 'partner/partner_group/mode';

    /**
     * XML Config path for custom order status toggle switch.
     */
    const USES_CUSTOM_ORDER_STATUS_XML_PATH = 'partner/partner_group/uses_custom_order_status';

    /**
     * XML Config path for custom order status value.
     */
    const CUSTOM_ORDER_STATUS_XML_PATH = 'partner/partner_group/custom_order_status';

    /**
     * @return string
     */
    public function getDownloadUrl()
    {
        return Mage::helper('adminhtml')->getUrl('adminhtml/partner_download/file');
    }

    /**
     * Returns the lifetime of the PartnerAds Cookie.
     * @return int|string
     */
    public function getCookieLifetime()
    {
        return self::COOKIE_TIME;
    }

    /**
     * Check if the cookie exists
     * @return bool
     */
    public function checkForCookie()
    {
        return (bool)Mage::getSingleton('core/cookie')->get('partner');
    }

    /**
     * Get the cookie value and decode it
     * @return bool|string
     */
    public function getCookie()
    {
        $cookie = Mage::getSingleton('core/cookie')->get('partner');

        return base64_decode($cookie);
    }

    /**
     * Creates a cookie out of the Partener ID and the PacId
     * @throws Mage_Core_Exception
     */
    public function createCookie()
    {
        $value = $this->getPartnerId() . '&' . $this->getPacId();
        $value = base64_encode($value);

        Mage::getSingleton('core/cookie')->set('partner', $value, $this->getCookieLifetime(), '/');

        Mage::register('partner', true);
    }

    /**
     * Gets the partner id from the URL
     * @return mixed
     * @throws Exception
     */
    public function getPartnerId()
    {
        return $this->_getRequest()->getParam('pa-partnerid');
    }

    /**
     * @return mixed|null
     */
    public function getPacId()
    {
        return $this->_getRequest()->getParam('pacid');
    }

    /**
     * Returns the program id from the configuration of a given store.
     * @param string|int $storeId
     * @return mixed
     */
    public function getProgramId($storeId)
    {
        static $programId;

        if (is_null($programId)) {
            $programId = [];
        }

        if (!isset($programId[$storeId])) {
            $programId[$storeId] = Mage::getStoreConfig(self::PROGRAM_ID_XML_PATH, $storeId);
        }

        return $programId[$storeId];
    }

    /**
     * Returns the program type from the configuration of a given store.
     * @param string|int $storeId
     * @return mixed
     */
    public function getProgramType($storeId)
    {
        static $programType;

        if (is_null($programType)) {
            $programType = [];
        }

        if (!isset($programType[$storeId])) {
            $programType[$storeId] = Mage::getStoreConfig(self::PROGRAM_TYPE_XML_PATH, $storeId);
        }

        return $programType[$storeId];
    }

    /**
     * Returns true if the given store is in test mode, false otherwise.
     * @param $storeId
     * @return mixed
     */
    public function getTestMode($storeId)
    {
        static $testMode;

        if (is_null($testMode)) {
            $testMode = [];
        }

        if (!isset($testMode[$storeId])) {
            $testMode[$storeId] = Mage::getStoreConfigFlag(self::TEST_MODE_XML_PATH, $storeId);
        }

        return $testMode[$storeId];
    }

    /**
     * Returns true if the given store is in debug mode, false otherwise.
     * @param $storeId
     * @return mixed
     */
    public function getDebugMode($storeId)
    {
        static $debugMode;

        if (is_null($debugMode)) {
            $debugMode = [];
        }

        if (!isset($debugMode[$storeId])) {
            $debugMode[$storeId] = Mage::getStoreConfigFlag(self::DEBUG_MODE_XML_PATH, $storeId);
        }

        return $debugMode[$storeId];
    }

    /**
     * @param string|int $storeId
     * @return bool
     */
    public function isEnabled($storeId)
    {
        static $enabled;

        if (is_null($enabled)) {
            $enabled = [];
        }

        if (!isset($enabled[$storeId])) {
            $enabled[$storeId] = Mage::getStoreConfigFlag(self::ENALBED_XML_PATH, $storeId);
        }

        return $enabled[$storeId];
    }

    /**
     * @param string|int $storeId
     * @return mixed
     */
    public function getTestEndpoint($storeId)
    {
        static $testEndpoint;

        if (is_null($testEndpoint)) {
            $testEndpoint = [];
        }

        if (!isset($testEndpoint[$storeId])) {
            $testEndpoint[$storeId] = Mage::getStoreConfig(self::TEST_ENDPOINT_XML_PATH, $storeId);
        }

        return $testEndpoint[$storeId];
    }

    /**
     * @param string|int $storeId
     * @return mixed
     */
    public function getMode($storeId)
    {
        static $mode;

        if (is_null($mode)) {
            $mode = [];
        }

        if (!isset($mode[$storeId])) {
            $mode[$storeId] = Mage::getStoreConfig(self::MODE_XML_PATH, $storeId);
        }

        return $mode[$storeId];
    }

    /**
     * @param string|int $storeId
     * @return mixed
     */
    public function getUsesCustomOrderStatus($storeId)
    {
        static $toggle;

        if (is_null($toggle)) {
            $toggle = [];
        }

        if (!isset($toggle[$storeId])) {
            $toggle[$storeId] = Mage::getStoreConfigFlag(self::USES_CUSTOM_ORDER_STATUS_XML_PATH, $storeId);
        }

        return $toggle[$storeId];
    }

    /**
     * @param string|int $storeId
     * @return mixed
     */
    public function getCustomOrderStatus($storeId)
    {
        static $statuses;

        if (is_null($statuses)) {
            $statuses = [];
        }

        if (!isset($statuses[$storeId])) {
            $statuses[$storeId] = Mage::getStoreConfig(self::CUSTOM_ORDER_STATUS_XML_PATH, $storeId);
        }

        return $statuses[$storeId];
    }
}
