<?php

class Partner_Module_Helper_Request extends Mage_Core_Helper_Abstract
{
    const PARTNER_ADS_URI = 'https://www.partner-ads.com/dk/leadtracks2s.php';

    /** @var array $processing */
    protected $processing = [];

    /** @var Varien_Http_Client|Varien_Object|null $httpClient */
    protected $httpClient = null;

    /** @var Partner_Module_Helper_Data|null $dataHelper */
    protected $dataHelper = null;

    /**
     * Partner_Module_Helper_Request constructor.
     */
    public function __construct()
    {
        $this->dataHelper = Mage::helper('partner_module');
    }

    /**
     * @param $storeId
     * @throws Zend_Http_Client_Exception
     */
    protected function configureHttpClient($storeId)
    {
        $testMode = $this->dataHelper->getTestMode($storeId);
        $testEndpoint = $this->dataHelper->getTestEndpoint($storeId);

        if ($testMode && empty($testEndpoint)) {
            $this->httpClient = new Varien_Object();
            $this->httpClient->setUri(self::PARTNER_ADS_URI);
            $this->httpClient->setMethod(Zend_Http_Client::GET);
        } else {
            if (!($this->httpClient instanceof Varien_Http_Client)) {
                $this->httpClient = new Varien_Http_Client((($testMode && !empty($testEndpoint)) ? $testEndpoint : self::PARTNER_ADS_URI));
                $this->httpClient->setMethod(Zend_Http_Client::GET);
            } else {
                $this->httpClient->resetParameters(true);
            }
        }
    }

    /**
     * @param Mage_Sales_Model_Order $order
     */
    protected function remove(Mage_Sales_Model_Order $order)
    {
        $key = array_search($order->getId(), $this->processing);
        if ($key !== false) {
            unset($this->processing[$key]);
        }
    }

    /**
     * @param Mage_Sales_Model_Order $order
     * @param bool $test
     * @return array|bool|null
     * @throws Zend_Http_Client_Exception
     */
    public function sendPartnerAdsRequest(Mage_Sales_Model_Order $order, $test = false)
    {
        $storeId = $order->getStoreId();

        if (!$this->dataHelper->isEnabled($storeId)) {
            return null;
        }

        if (in_array($order->getId(), $this->processing)) {
            return null;
        }

        $this->processing[] = $order->getId();

        $this->configureHttpClient($storeId);

        $debugMode = $this->dataHelper->getDebugMode($storeId);
        $programType = $this->dataHelper->getProgramType($storeId);
        $programId = $this->dataHelper->getProgramId($storeId);

        if ($order->getData('partnerads_order_sent') != 0) {
            $this->remove($order);
            if ($test === true) {
                echo var_export($order->getData('partnerads_order_sent'), true) . ' != 0' . PHP_EOL;
            }
            return null;
        }
        if($debugMode){
            Mage::log("(Send request) ProgramId: $programId, ProgramType: $programType, for orderID: " .
                $order->getId(),
                null,"Partner.debug.log", true);
        }


        $customOrderStatus = $this->dataHelper->getUsesCustomOrderStatus($storeId);
        if (
            (!$customOrderStatus && $order->getData('status') != Mage_Sales_Model_Order::STATE_PROCESSING)
            || ($customOrderStatus && $order->getData('status') != $customOrderStatus)
        ) {
            $this->remove($order);
            if ($test === true) {
                if ($customOrderStatus) {
                    echo var_export($order->getData('status'), true) .
                        ' != ' .
                        var_export($customOrderStatus, true) . PHP_EOL;
                } else {
                    echo var_export($order->getData('status'), true) .
                        ' != ' .
                        var_export(Mage_Sales_Model_Order::STATE_PROCESSING, true) . PHP_EOL;
                }
            }
            return null;
        }

        if (empty($programType) || (empty($programId))) {
            if ($test === true) {
                if (empty($programType)) {
                    echo 'ProgramType is empty.' . PHP_EOL;
                }
                if (empty($programId)) {
                    echo 'ProgramId is empty.' . PHP_EOL;
                }
            }
            $this->remove($order);
            return false;
        }

        if (!$order->hasData('partnerads_partner_id')) {
            if ($test === true) {
                if (!$order->hasData('partnerads_partner_id')) {
                    echo 'Order is missing "partnerads_partner_id".' . PHP_EOL;
                }
            }
            if($debugMode){
                Mage::log("(Send request) partnerads_partner_id missing from order: " . $order->getId(),null,"Partner.debug.log",
                    true);
            }
            $this->remove($order);
            return false;
        }

        $isShippingInclTax = Mage::getStoreConfigFlag('tax/calculation/shipping_includes_tax', $order->getStore());
        $shippingCost = ($isShippingInclTax ? $order->getShippingInclTax() : $order->getShippingAmount());
        $grandTotal = (string)$order->getGrandTotal();
        $shipping = (is_numeric($shippingCost) ? (string)$shippingCost : '0');

        $totalItemCost = bcsub($grandTotal, $shipping, 4);

        $requestData = [
            'programid' => $programId,
            'type' => $programType,
            'partnerid' => $order->getData('partnerads_partner_id'),
            'pacid' => $order->hasData('partnerads_pacid_id') ? $order->getData('partnerads_pacid_id') : '',
            'ordreid' => $order->getIncrementId(),
            'varenummer' => 'x',
            'antal' => '1',
            'omprsalg' => $totalItemCost,
        ];

        if($debugMode){
            Mage::log("(Send request) " . var_export($requestData,true) . " for ordreID: " .  $order->getId(),null,"Partner.debug.log",
                true);
        }

        $this->httpClient->setParameterGet($requestData);

        if ($test === true) {
            echo 'Request Data has been Set:' . PHP_EOL;
            var_dump($requestData);
        }

        if ($this->httpClient instanceof Varien_Http_Client) {
            try {
                /** @var Zend_Http_Response $response */
                $response = $this->httpClient->request();

                if ($response->isSuccessful()) {

                    if ($test === true) {
                        echo 'Success Response Gotten' . PHP_EOL;
                    }

                    $order->setData('partnerads_order_sent', 1);

                    $order->save();

                    if ($test === true) {
                        echo '"partnerads_order_sent" set to TRUE on Order' . PHP_EOL;
                    }

                    $this->remove($order);

                    return true;
                }
                $responseCodeMsg =  'ResponseCode: ' . var_export($response->getStatus(), true) . PHP_EOL;
                $reponseMessageMsg = 'ResponseMessage: ' . var_export($response->getMessage(), true) . PHP_EOL;
                if ($test === true) {
                    echo 'Response from PartnerAds was Unsuccessful' . PHP_EOL;
                    echo $responseCodeMsg;
                    echo $reponseMessageMsg;
                } else {
                    Mage::log('Response from PartnerAds was Unsuccessful. ResponseCode: "' . $response->getStatus() . '" ResponseMessage: "' . $response->getMessage() . '".', Zend_Log::ERR, 'PartnerAds.error.log', true);
                }

                if($debugMode){
                    Mage::log("(Send request) $responseCodeMsg $reponseMessageMsg" . " for ordreID: " .  $order->getId(),null,"Partner.debug.log",
                        true);
                }

                $this->remove($order);
                return $requestData;

            } catch (Exception $exception) {
                if ($test === true) {
                    echo 'Exception was caught from request' . PHP_EOL;
                    echo $exception . PHP_EOL;
                } else {
                    Mage::logException($exception);
                }
                $this->remove($order);
                return false;
            }
        } else {
            if($debugMode){
                Mage::log("(Send request) " . $this->httpClient->getData() . " for ordreID: " .  $order->getId(),null,"Partner.debug.log",
                    true);
            }
            if ($test === true) {
                var_dump($this->httpClient->getData());
            } else {
                Mage::log(var_export($this->httpClient->getData(), true), Zend_Log::DEBUG, 'Partner.debug.log', true);
            }
            $this->remove($order);
            return null;
        }
    }
}
