<?php
/**
 * https://www.wexo.dk/
 *
 * @author    Paul-Daniel Savlovschi <paul@wexo.dk>
 * @copyright Copyright (c) 2018, WEXO A/S
 */

class Partner_Module_Model_Observer
{
    /** @var Partner_Module_Helper_Data|null $helper */
    protected $helper = null;

    /** @var Partner_Module_Helper_Request|null $requestHelper */
    protected $requestHelper = null;

    /** @var Partner_Module_Helper_Csv|null */
    protected $csvHelper = null;

    public function __construct()
    {
        $this->helper = Mage::helper('partner_module');
        $this->requestHelper = Mage::helper('partner_module/request');
        $this->csvHelper = Mage::helper('partner_module/csv');
    }

    /**
     * Event: admin_system_config_changed_section_partner
     * @param Varien_Event_Observer $observer
     * @throws Mage_Core_Exception
     * @throws Mage_Core_Model_Store_Exception
     */
    public function configChange(Varien_Event_Observer $observer)
    {

        $store = Mage::app()->getStore();

        if ($store->getId() == 0) {
            $real_store = Mage::getModel('core/store')->load(1);
        } else {
            $real_store = $store;
        }

        $store_name = !$store->getId() ? $real_store->getFrontendName() : $store->getFrontendName();
        $store_url = !$store->getId() ? $real_store->getBaseUrl() : $store->getBaseUrl();

        Mage::getModel('partner_module/email')->sendEmail(
            'partner_module_email_template',
            array('name' => Mage::getStoreConfig('trans_email/ident_general/name', $real_store), 'email' => Mage::getStoreConfig('trans_email/ident_general/email', $real_store)),
            'supportdk@partner-ads.com',
            'Partnerads',
            'Partner-ads Magento Plugin Aktiveret',
            array(
                'store_name' => $store_name,
                'store_url' => $store_url,
                'program_id' => Mage::getStoreConfig('partner/partner_group/program_id', $real_store)
            )
        );
    }

    /**
     * Event: sales_order_place_after
     * @param Varien_Event_Observer $observer
     * @throws Exception
     */
    public function orderPlace(Varien_Event_Observer $observer)
    {
        /** @var Mage_Sales_Model_Order $order */
        $order = $observer->getEvent()->getOrder();

        if($this->helper->getDebugMode($order->getStoreId()))
        {
            Mage::log("Order place for " . $order->getId(),null,"Partner.debug.log",true);
        }

        if (($this->helper->checkForCookie()) && $this->helper->isEnabled($order->getStoreId())) {

            $cookie = explode("&", $this->helper->getCookie());

            $partner_id = $cookie[0];
            $pacid = $cookie[1] ? $cookie[1] : '';

            $order->setData('partnerads_partner_id', $partner_id);
            $order->setData('partnerads_pacid_id', $pacid);
            $order->setData('partnerads_order_sent', 0);

            if($this->helper->getDebugMode($order->getStoreId()))
            {
                $str = "PartnerID: $partner_id, pacID: $pacid. Order ID was: " . $order->getId();
                Mage::log($str,null,"Partner.debug.log",true);
            }

            $order->save();
        }
    }

    /**
     * Event: sales_order_save_after
     * @param Varien_Event_Observer $observer
     * @throws Zend_Http_Client_Exception
     * @deprecated
     */
    public function orderStatusChange(Varien_Event_Observer $observer)
    {
        /** @var Mage_Sales_Model_Order $order */
        $order = $observer->getEvent()->getOrder();

        if (true !== ($order instanceof Mage_Sales_Model_Order)) {
            return;
        }

        if($this->helper->getDebugMode($order->getStoreId()))
        {
            Mage::log("Order status changed for " . $order->getId(),null,"Partner.debug.log",true);
        }

//        if ($this->helper->getMode($order->getStoreId()) != Partner_Module_Model_System_Config_Source_Mode::OBSERVER) {
//            return;
//        }

        $status = $this->requestHelper->sendPartnerAdsRequest($order);

        if (is_array($status)) {
            $this->csvHelper->logData($status);
        } else {
            //this is to prevent logging of failure or success when the status is null
            if ($status === true) {
                Mage::log('Successfully exported order: #' . $order->getIncrementId(), Zend_Log::INFO, 'Partner.info.log', true);
            } elseif ($status === false) {
                Mage::log('Failed export of order: #' . $order->getIncrementId(), Zend_Log::ERR, 'Partner.error.log', true);
            }
        }
    }

    /**
     * Event: controller_action_layout_load_before
     * @param Varien_Event_Observer $observer
     * @throws Mage_Core_Exception
     */
    public function frontendLoaded(Varien_Event_Observer $observer)
    {
        if ($this->helper->getPartnerId()) {

            if (!$this->helper->checkForCookie()) {
                $this->helper->createCookie($this->helper->getPartnerId());
            }
        }
    }

    public function partner_order_export()
    {
//        $orderCollection = Mage::getModel('sales/order')
//            ->getCollection()
//            ->addAttributeToSelect('*')
//            ->addAttributeToFilter('status', ['eq' => Mage_Sales_Model_Order::STATE_PROCESSING])
//            ->addAttributeToFilter('partnerads_order_sent', ['eq' => 0]);
//
//        foreach ($orderCollection as $order) {
//            /** @var Mage_Sales_Model_Order $order */
//
//            if (true !== ($order instanceof Mage_Sales_Model_Order)) {
//                continue;
//            }
//
//            if ($this->helper->getMode($order->getStoreId()) != Partner_Module_Model_System_Config_Source_Mode::CRONJOB) {
//                continue;
//            }
//
//            $status = $this->requestHelper->sendPartnerAdsRequest($order);
//
//            //this is to prevent logging of failure or success when the status is null
//            if (true === $status) {
//                Mage::log('Successfully exported order: #' . $order->getIncrementId(), Zend_Log::INFO, 'Partner.info.log', true);
//            } elseif (false === $status || is_array($status)) {
//                Mage::log('Failed export of order: #' . $order->getIncrementId(), Zend_Log::ERR, 'Partner.error.log', true);
//            }
//        }
    }

    /**
     * @param $observer
     */
    public function coreBlockAbstractToHtmlAfter($observer)
    {
        $block = $observer->getBlock();

        if(!$block){
            return;
        }

        $transport = $observer->getTransport();

        $link = Mage::helper('partner_module')->getDownloadUrl();

        if(
            ($block instanceof Mage_Adminhtml_Block_System_Config_Form || $block instanceof Mage_Adminhtml_Block_System_Config_Edit) &&
            $transport &&
            $transport->hasData('html')
        ){
            $html = str_replace('$_$__REPLACE_ME_PARTNER_MODULE__$_$','<a href="'.$link.'">Download Failed Exports</a>',$transport->getData('html'));
            $observer->getTransport()->setData('html',$html);
        }
    }
}
