<?php

require_once rtrim(__DIR__, DIRECTORY_SEPARATOR ) . DIRECTORY_SEPARATOR . 'abstract.php';

class partner_test extends Mage_Shell_Abstract
{

    public $argument = null;

    public function run()
    {
        /** @var Partner_Module_Helper_Request $helper */
        $helper = Mage::helper('partner_module/request');

        if (!is_numeric($this->argument) || empty($this->argument)) {
            die('Invalid Order Id.' . PHP_EOL);
        }

        $order = Mage::getModel('sales/order')->load($this->argument);

        if (empty($order->getId()) || !is_numeric($order->getId())) {
            die('Failed to find order.' . PHP_EOL);
        }

        var_dump($helper->sendPartnerAdsRequest($order, true));

    }

}
if ($argc == 2) {
    $shell = new partner_test();
    $shell->argument = $argv[1];
    $shell->run();
} else {
    echo 'Missing Order Id Argument.' . PHP_EOL;
}
