(function() {
    var copyToClipboard = function(str) {
        var el = document.createElement('textarea');
        el.value = str;
        el.setAttribute('readonly', '');
        el.style.position = 'absolute';
        el.style.left = '-9999px';
        document.body.appendChild(el);
        el.select();
        document.execCommand('copy');
        document.body.removeChild(el);
    }

    var copyFeedButtons = document.querySelectorAll('.js-copy-partner-ads-feed-link');
    for (let index = 0; index < copyFeedButtons.length; index++) {
        const element = copyFeedButtons[index];

        element.onclick = function(e) {
            e.preventDefault();
            const str = element.parentNode.parentNode.querySelector('input').value;
            copyToClipboard(str);

            const innerHtml = element.innerHTML;
            element.innerHTML = WCPA.copied;
            setTimeout(function() {
                element.innerHTML = innerHtml;
            }, 2000);
        }
    }


    ['feed_color', 'feed_size', 'feed_brand', 'feed_gender'].forEach(function(value) {
        if(document.querySelector('#woocommerce_partner-ads_'+ value)) {
            document.querySelector('#woocommerce_partner-ads_'+ value).addEventListener('change', function() {
                const custom_tr = document.querySelector('#woocommerce_partner-ads_'+ value +'_custom').closest('tr')
                if (this.value === 'custom_attribute') {
                    custom_tr.style.display = "";
                } else {
                    custom_tr.style.display = "none";
                }
            });
            document.querySelector('#woocommerce_partner-ads_' + value).dispatchEvent(new Event('change'));
        }
    });


    const generate_feed_button = document.querySelector('#woocommerce_partner-ads_feed_generate_button');
    if (generate_feed_button) {
        let button_text = '';
        let generating = false;

        const check_progress = function() {
            jQuery.ajax({
                type: "POST",
                url: ajaxurl,
                data: {
                    action: 'partner_ads_progress_feed',
                },
                success: function(response) {
                    if (response.finised === false) {
                        generate_feed_button.innerText = WCPA.processing + ' - ' + response.progress + '%';
                    } else {
                        generate_feed_button.innerText = WCPA.finished;
                        generating = false;
                        setTimeout(() => {
                            generate_feed_button.innerText = button_text;
                        }, 3000)
                    }

                },
            }).always(function (response) {
                if (response.finised === false) {
                    setTimeout(() => {
                        check_progress();
                    }, 5000)
                }
            });
        }

        generate_feed_button.addEventListener('click', function(e) {
            e.preventDefault();
            if (generating) {
                return;
            }

            generating = true;
            button_text = generate_feed_button.innerText;

            jQuery.ajax({
                type: "POST",
                url: ajaxurl,
                data: {
                    action: 'partner_ads_generate_feed',
                },
                success: function() {
                    generate_feed_button.innerText = WCPA.processing + ' - 0%';
                    setTimeout(() => {
                        check_progress();
                    }, 2000)
                },
            });
        });
    }
})()
