(function() {
    function reloadPaQueries() {
        if(!window.partnerAdsWooCommerce.update_url_with_variable || window.partnerAdsWooCommerce.update_url_with_variable != 'yes') {
            return;
        }

        let paQueries;
        var name = "partner-ads-query=";
        var decodedCookie = decodeURIComponent(document.cookie);
        var ca = decodedCookie.split(';');
        ca.forEach(function(c) {
            while (c.charAt(0) == ' ') {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                paQueries = JSON.parse(atob(c.substring(name.length, c.length)));
            }
        });

        if (paQueries) {
            let url = window.location.href;
            let queries = [];
            for (const key in paQueries) {
                if (paQueries.hasOwnProperty(key)) {
                    const value = paQueries[key];
                    queries.push(key +'='+ value);
                }
            }

            if (queries.length > 0) {
                url += '?'+ queries.join('&');
                window.history.replaceState({}, document.title, url);
            }
        }
    }

    if (window.location.search) {
        const queries = location.search.replace('?','').split('&');
        const paQueries = {};

        for (let index = 0; index < queries.length; index++) {
            const query = queries[index];

            if (
                query.match(/pa-/)
                ||
                query.match(/pacid/)
            ) {
                [key, value] = query.split('=');

                paQueries[key] = value;
            }
        }

        if (Object.keys(paQueries).length > 0) {
            var d = new Date();
            d.setTime(d.getTime() + (60 * 60 * 24 * 40*1000));
            var expires = "expires="+ d.toUTCString();

            document.cookie = "partner-ads-query="+ btoa(JSON.stringify(paQueries)) +"; expires="+ expires +"; path=/";
        } else {
            reloadPaQueries();
        }
    } else {
        reloadPaQueries();
    }
})();
