<?php

/**
 * Plugin Name: Partner-ads Woocommerce tracking and feed
 *
 * Plugin URI: http://partner-ads.com
 * Description: Integrate tracking with Partner-ads and creates a feed. <a href="/wp-admin/admin.php?page=wc-settings&tab=integration&section=partner-ads">Go to integration</a>.
 * Integrér tracking med Partner-annoncer og opretter et feed.
 * Version: 1.52.0
 * Author: Partner-ads
 * Author URI: http://partner-ads.com
 * License: GNU GENERAL PUBLIC LICENSE
 * Text Domain: partner-ads-woocommerce
 * Domain Path: /languages/
 */

if (!defined('ABSPATH')) {
    die; // Exit if accessed directly.
}

require __DIR__ . '/autoload.php';

if (!defined('PARTNER_ADS_WOOCOMMERCE_PLUGIN_URL')) {
    define('PARTNER_ADS_WOOCOMMERCE_PLUGIN_URL', plugin_dir_url(__FILE__));
}

if (!defined('PARTNER_ADS_WOOCOMMERCE_PLUGIN_PATH')) {
    define('PARTNER_ADS_WOOCOMMERCE_PLUGIN_PATH', plugin_dir_path(__FILE__));
}

$partnerAdsWooCommerce = new \PartnerAdsWooCommerce\PartnerAds();
$partnerAdsWooCommerce->pluginPath = plugin_dir_path(__FILE__);
$partnerAdsWooCommerce->pluginUrl = plugin_dir_url(__FILE__);
$partnerAdsWooCommerce->file = __FILE__;
$partnerAdsWooCommerce->init();

require_once plugin_dir_path(__FILE__) . 'vendor/yahnis-elsts/plugin-update-checker/plugin-update-checker.php';
$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
    'https://www.partner-ads.com/dk/partner-ads-woocommerce.json',
    __FILE__,
    'partner-ads-woocommerce'
);
