<?php


namespace PartnerAdsWooCommerce\Admin;

use PartnerAdsWooCommerce\Settings\Setting;

class ProductMetaController
{
    public function __construct()
    {
        add_action('woocommerce_product_options_general_product_data', [$this, 'edit'], 20);
        add_action('save_post_product', [$this, 'update']);
    }

    public function edit()
    {
        global $post;
        $exclude = get_post_meta($post->ID, 'exclude_partner_ads_feed', true);
        $content_field = get_post_meta($post->ID, 'partner_ads_content_field', true);
        $show_content_field = Setting::get('feed_descriptions_field') == 'custom_content';
        include_once PARTNER_ADS_WOOCOMMERCE_PLUGIN_PATH .'/templates/post_meta_fields.php';
    }

    public function update($post_id)
    {
        $exclude_from_feed = (isset($_REQUEST['exclude_partner_ads_feed']) && $_REQUEST['exclude_partner_ads_feed']) == 'yes';
        update_post_meta($post_id, 'exclude_partner_ads_feed', $exclude_from_feed);
        if (Setting::get('feed_descriptions_field') == 'custom_content') {
            update_post_meta($post_id, 'partner_ads_content_field', $_REQUEST['partner_ads_content_field']);
        }
    }
}
