<?php

namespace PartnerAdsWooCommerce\Admin;

class ScriptsController
{
    public function __construct()
    {
        add_action('admin_enqueue_scripts', [$this, 'enqueueScripts']);
    }

    public function enqueueScripts()
    {
        $screen = get_current_screen();

        if ($screen && $screen->id == 'woocommerce_page_wc-settings') {
            wp_enqueue_script(
                'partner-ads-woocommerce-admin-js',
                PARTNER_ADS_WOOCOMMERCE_PLUGIN_URL . 'assets/js/admin.js',
                [],
                '1.0',
                true
            );

            wp_localize_script('partner-ads-woocommerce-admin-js', 'WCPA', [
                'copied' => __('Copied', 'partner-ads-woocommerce'),
                'processing' => __('Processing', 'partner-ads-woocommerce'),
                'finished' => __('Finished', 'partner-ads-woocommerce'),
            ]);
        }
    }
}
