<?php


namespace PartnerAdsWooCommerce\Feed;


use PartnerAdsWooCommerce\Feed\Mapping\XmlMapper;
use PartnerAdsWooCommerce\Settings\Setting;

class Controller
{


    /**
     * Feed constructor.
     */
    public function __construct()
    {
        add_action('admin_action_partner_ads_generate_feed', [$this, 'generateFeed']);
        add_action('wp_ajax_partner_ads_generate_feed', [$this, 'startGenerateFeed']);
        add_action('wp_ajax_partner_ads_progress_feed', [$this, 'progress']);
        add_action('partner_ads_regenerate_feed_twice_daily', [$this, 'cronGenerateFeed']);
        add_action('partner_ads_batch_generate_feed', [$this, 'generateFeed']);
    }

    public function startGenerateFeed()
    {
        delete_option('partner-ads-generating_feed');
        $this->generateFeed();
    }

    public function cronGenerateFeed()
    {
        if(Setting::get('disable_feed') != 'yes') {
            delete_option('partner-ads-generating_feed');
            $this->generateFeed();
        }
    }

    public function generateFeed()
    {
        $generator = new Generator();
        $generator->writeFeed();


        if (wp_doing_ajax()) {
            wp_send_json_success();
        }
    }

    public function progress()
    {
        $generating_feed = get_option('partner-ads-generating_feed', false);
        if ($generating_feed) {
            $progress = (count($generating_feed['da']['post__not_in']) / $generating_feed['count_products']->publish) * 100;
            $progress = number_format($progress, 0);
            if ($progress == 100) {
                $progress = 99;
            }

            wp_send_json([
                'finised' => false,
                'progress' => $progress,
            ]);
        } else {
            wp_send_json([
                'finised' => true,
                'progress' => 100,
            ]);
        }
    }

}
