<?php


namespace PartnerAdsWooCommerce\Feed\Mapping;

use PartnerAdsWooCommerce\Settings\Setting;

class XmlMapper implements Mapper
{
    
    private $products;

    /**
     * Mapping constructor.
     * @param array $products
     */
    public function __construct(array $products)
    {
        $this->products = $products;
    }

    public function map($new_file = false)
    {
        $xml = new SimplexXmlExtended('<xml/>');
        if ($new_file) {
            $xml->addChild('Shop', get_bloginfo('name'));
            $xml->addChild('url', get_bloginfo('url'));
            $xml->addChild('last-update', (new \DateTime('NOW'))->format('Y-m-d H:i:s'));
        }

        $products = $xml->addChild('products');
        $allowDescriptions = Setting::get('feed_enabled_descriptions', false) == 'no' ? false : true;

        foreach ($this->products as $productAttributes) {
            $product = $products->addChild('product');
            foreach ($productAttributes as $key => $value) {
                if(is_array($value)) {
                    $subChild = $product->addChild($key);
                    $parentKey = $key;
                    foreach ($value as $key => $value) {
                        if (!is_array($value) && is_string($value)) {
                            $subChild->addCData($parentKey.'-'.$key, $value);
                        }
                    }
                    continue;
                }
                
                if(($key == 'description' || $key == 'short_description') && !$allowDescriptions) {
                    continue;
                }

                $product->addCData($key, $value);
            }
        }

        $xml = $xml->asXML();
        if (!$new_file) {
            $xml = str_replace(['<xml>', '</xml>', '<?xml version="1.0"?>', '<products>', '</products>'], '', $xml);

        } else {
            $xml = str_replace(['</products>', '</xml>'], '', $xml);
        }

        return $xml;
    }
}