<?php

namespace PartnerAdsWooCommerce\Settings;

class Setting
{
    /**
     * Get a Setting
     * @param $key
     * @param string $default
     * @return string
     */
    public static function get($key, $default = '')
    {
        $settings = get_option('woocommerce_partner-ads_settings', []);

        if ($key == 'program_id' && function_exists('wpml_language_is_active_filter')) {
            $languageCode = ICL_LANGUAGE_CODE;
            if($languageCode == 'se') {
                $languageCode = 'sv';
            }
            $key = $languageCode . '_program_id';

            if (!in_array(ICL_LANGUAGE_CODE, ['da', 'no', 'sv', 'se'])) {
                $key = self::get('fallback_country') . '_program_id';
            }
        }

        return isset($settings[$key]) ? $settings[$key] : $default;
    }

    public static function update($key, $value)
    {
        $settings = get_option('woocommerce_partner-ads_settings', []);
        $settings[$key] = $value;
        update_option('woocommerce_partner-ads_settings', $settings);
    }

    public static function getCountryEmail()
    {
        $country = self::get('country');

        if (function_exists('wpml_language_is_active_filter')) {
            $key = ICL_LANGUAGE_CODE;
            if (!in_array(ICL_LANGUAGE_CODE, ['da', 'no', 'sv', 'se'])) {
                $key = self::get('fallback_country');
            }

            switch ($key) {
                case 'sv':
                    $email = 'supportse@partner-ads.com';
                    break;
                case 'ses':
                    $email = 'supportse@partner-ads.com';
                    break;
                case 'no':
                    $email = 'supportno@partner-ads.com';
                    break;

                default:
                    $email = 'supportdk@partner-ads.com';
            }
        }

        switch ($country) {
            case 'sweden':
                $email = 'supportse@partner-ads.com';
                break;
            case 'norway':
                $email = 'supportno@partner-ads.com';
                break;

                default:
                $email = 'supportdk@partner-ads.com';
        }

        return $email;
    }

    public static function getCountryUrl()
    {
        $country = self::get('country');

        if (function_exists('wpml_language_is_active_filter')) {
            $key = ICL_LANGUAGE_CODE;
            if (!in_array(ICL_LANGUAGE_CODE, ['da', 'no', 'sv', 'se'])) {
                $key = self::get('fallback_country');
            }

            switch ($key) {
                case 'sv':
                    return 'https://partner-ads.com/se/';

                case 'se':
                    return 'https://partner-ads.com/se/';

                case 'no':
                    return 'https://partner-ads.com/no/';

                case 'dk':
                    return 'https://partner-ads.com/dk/';
            }

            $country = self::get('fallback_country');
        }

        switch ($country) {
            case 'sweden':
                $url = 'https://partner-ads.com/se/';
                break;
            case 'norway':
                $url = 'https://partner-ads.com/no/';
                break;

            default:
                $url = 'https://partner-ads.com/dk/';
        }

        return $url;
    }
}
