<?php

namespace PartnerAdsWooCommerce\Util;

use PartnerAdsWooCommerce\Settings\Setting;

class Log
{

    public static function log($type = 'EVENT', $message = '')
    {
        if (Setting::get('activate_logging') != 'yes') {

            return;
        }

        $message = date('Y-m-d H:i:s') . ': '. $type .' '. $message . "\n";


        $filePath = self::getFilePath();

        $fp = fopen($filePath, 'a+');
        fwrite($fp, $message);
        fclose($fp);
    }

    public static function getFilePath()
    {
        $upload_dir = wp_upload_dir();
        $directory = '/partner-ads-feed/';
        $path = $upload_dir['basedir'] . $directory;
        if (!file_exists($path)) {
            wp_mkdir_p($path);
        }

        return $path .'/partner-ads.log';
    }

    public static function getUrl()
    {
        $upload_dir = wp_upload_dir();
        $baseUrl = $upload_dir['baseurl'];
        if (is_ssl() && preg_match('/http:\/\//', $baseUrl)) {
            $baseUrl = str_replace('http://', 'https://', $baseUrl);
        }
        $directory = '/partner-ads-feed/';
        $fileName = 'partner-ads.log';

        return $baseUrl . $directory . $fileName;
    }
}
